<?php

/**
 * This is the model class for table "Oplaty".
 *
 * The followings are the available columns in table 'Oplaty':
 * @property double $id
 * @property double $rodzajOplaty
 * @property double $idFirmy
 * @property double $idKontrahenta
 * @property string $tytul
 * @property double $wartosc
 * @property string $czas
 * @property double $idBiura
 * @property double $idPracownika
 * @property double $idBanku
 *
 * @property double $target
 * @property double $czasYmd
 *
 * @property Firma      $firma
 * @property Kontrahent $kontrahent
 * @property Biuro      $biuro
 * @property Pracownik  $pracownik
 * @property Bank       $bank
 */
class Oplaty extends CActiveRecord
{
	const TYPE_TASK_PAYMENT = 1;
	const TYPE_OFFICE = 2;
	const TYPE_BANK = 3;
	const TYPE_WORKER = 4;
	const TYPE_TAX = 5;
	const TYPE_VAT = 6;
	const TYPE_ZUS_US = 7;
	const TYPE_ZUS_UZ = 8;
	const TYPE_ZUS_FP = 9;
	const TYPE_ZUS_FEP = 10;
	const TYPE_BANK_TRANSFER = 11;
	const TYPE_DONATION_TRANSFER = 12;
	const TYPE_US = 13;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Oplaty the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Oplaty';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idFirmy, rodzajOplaty', 'required'),
			array('rodzajOplaty, idFirmy, idKontrahenta, idBiura, idBanku, idPracownika', 'numerical'),
			array('wartosc', 'type', 'type'=>'float'),
			array('tytul', 'length', 'max'=>128),
			array('czas', 'safe'),

			array('rodzajOplaty, idFirmy, tytul, wartosc', 'required', 'on' => 'insert'),

			array('id, rodzajOplaty, idFirmy, idKontrahenta, tytul, wartosc, czas, idBiura, idBanku,idPracownika', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'firma'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
			'kontrahent'=>array(self::BELONGS_TO, 'Kontrahent', 'idKontrahenta'),
			'biuro'=>array(self::BELONGS_TO, 'Biuro', 'idBiura'),
			'pracownik'=>array(self::BELONGS_TO, 'Pracownik', 'idPracownika'),
			'bank'=>array(self::BELONGS_TO, 'Bank', 'idBanku'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Oplaty', 'id'),
			'rodzajOplaty'=>Yii::t('Oplaty', 'rodzajOplaty'),
			'idFirmy'=>Yii::t('Oplaty', 'idFirmy'),
			'idKontrahenta'=>Yii::t('Oplaty', 'idKontrahenta'),
			'tytul'=>Yii::t('Oplaty', 'tytul'),
			'wartosc'=>Yii::t('Oplaty', 'wartosc'),
			'czas'=>Yii::t('Oplaty', 'czas'),
			'idBiura'=>Yii::t('Oplaty', 'idBiura'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('rodzajOplaty', $this->rodzajOplaty);
		$criteria->compare('idFirmy', $this->idFirmy);
		$criteria->compare('idKontrahenta', $this->idKontrahenta);
		$criteria->compare('tytul', $this->tytul, true);
		$criteria->compare('wartosc', $this->wartosc);
		$criteria->compare('czas', $this->czas, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getCzasYmd()
	{
		return empty($this->czas) ? '' : date('Y/m/d', strtotime($this->czas));
	}

	static public function analyzeBiuroPlayments(Firma &$company)
	{
		$undertakings = array();

		foreach($company->biura as $biuro)
		{
			$undertakings[] = array(
				'value'=>$biuro->cenaWynajem + $biuro->cenaMedia,
				'who'=>$biuro->budynek->opis.' ('.$biuro->budynek->adres.')',
				'details'=>'Wynajem biura',
			);
		}

		return $undertakings;
/*
		//pobierz liste biur, oplat itp.
		$offices = Yii::app()->db->createCommand('
			select x.*, nvl(y."payed", 0) "payed", b."cenaWynajem", b."cenaMedia", bud."opis", bud."adres" from (
				select bf."idBiura",
					sum(MONTHS_BETWEEN(nvl(bf."czasRezygnacji", :now), bf."czasWynajmu")) "months",
					sum(case when bf."czasRezygnacji" IS NULL THEN 1 else 0 end) "rented"
				from "BiuroFirmy" bf
				where bf."idFirmy" = :companyId
				group by bf."idBiura") x
			left join (
				select o."idBiura", sum(o."wartosc") "payed" from "Oplaty" o
				where o."idFirmy" = :companyId and o."idBiura" is not null and o."wartosc" < 0
				group by o."idBiura"
			) y on x."idBiura" = y."idBiura"
      left join "Biuro" b on b."id" = x."idBiura"
      left join "Budynek" bud on bud."id" = b."idBudynku"
		')->queryAll(true, array(
			':now' => date('d-m-Y H:i:s'),
			':companyId' => $company->id
		));

		$undertakings = array();

		foreach($offices as $office)
		{
			$rented = (int)$office['rented'];
			$months = (float)$office['months'];
			$cost = (float)$office['cenaWynajem'] + (float)$office['cenaMedia'];
			$payed = (float)$office['payed'];

			$undertaking = ($rented ? floor($months) : $months) * $cost + $payed;

			if ($undertaking > 0)
			{
				$undertakings[] = array(
					'value' => $undertaking,
					'who' => $office['opis'] . ' (' . $office['adres'] . ')',
					'details' => 'Wynajem (' . $office['cenaWynajem'] . ' zł) + Media ('
						. $office['cenaMedia'] . ' zł).'
				);
			}
			else if (!$rented && $undertaking < 0)
			{
				$refound = new Oplaty();
				$refound->idBiura = $office['idBiura'];
				$refound->idFirmy = $company->id;
				$refound->rodzajOplaty = self::TYPE_OFFICE;
				$refound->tytul = 'Nadpłata od ' . $office['opis'] . ' (' . $office['adres'] . ')';
				$refound->wartosc = abs($undertaking);
				//$refound->save(false);

				$company->stanKonta += $refound->wartosc;
				$company->updated = true;
			}
		}

		return $undertakings;
*/
	}

	static public function analyzeBankPlayments(Firma &$company, $lessonNumber)
	{
		$undertakings = array();

		if($company->bank !== null)
		{
			$akcjePodsumowanie = null;
			if($lessonNumber == 7)
			{
				$akcjePodsumowanie = AkcjaUzytkownika::model()->findAll(array(
					'condition'=>'"idFirmy" = :id_firmy AND "idAkcji" = :id_akcji',
					'params'=>array(
						':id_firmy'=>$company->id,
						':id_akcji'=>173,
					)
				));
			}
			elseif($lessonNumber == 11)
			{
				$akcjePodsumowanie = AkcjaUzytkownika::model()->findAll(array(
					'condition'=>'"idFirmy" = :id_firmy AND "idAkcji" = :id_akcji',
					'params'=>array(
						':id_firmy'=>$company->id,
						':id_akcji'=>174,
					)
				));
			}
			elseif($lessonNumber == 15)
			{
				$akcjePodsumowanie = AkcjaUzytkownika::model()->findAll(array(
					'condition'=>'"idFirmy" = :id_firmy AND "idAkcji" = :id_akcji',
					'params'=>array(
						':id_firmy'=>$company->id,
						':id_akcji'=>175,
					)
				));
			}

			if($akcjePodsumowanie == null)
			{
				$transaction = Yii::app()->db->beginTransaction();
                		try
                		{
					// prowadzenie konta
					$payment = new Oplaty;
					$payment->idBanku = $company->idBanku;
					$payment->idFirmy = $company->id;
					$payment->rodzajOplaty = self::TYPE_BANK;
					$payment->tytul = 'Opłata za prowadzenie konta';
					$payment->wartosc = -$company->bank->oplataMiesieczna;
					$payment->czas = new CDbExpression('SYSDATE');
					$payment->save(false);

					$company->stanKonta -= $company->bank->oplataMiesieczna;
					$company->updated = true;

					$undertakings[0] = array(
						'value'=>$company->bank->oplataMiesieczna,
						'who'=>strip_tags($company->bank->opis),
						'details'=>'Opłata za prowadzenie konta',
					);

	                        	$company->save(false);
	                        	$transaction->commit();
				} 
                		catch (Exception $e)
                		{
                        		echo '<script type="text/javascript"> console.log('.$e->getMessage().'); </script>';
                        		$transaction->rollback();
                		}

				$transaction = Yii::app()->db->beginTransaction();
                		try
                		{
					// kapitalizacja odsetek (oprocentowanie)	
					$payment = new Oplaty;
					$payment->idBanku = $company->idBanku;
					$payment->idFirmy = $company->id;
					$payment->rodzajOplaty = self::TYPE_BANK;
					$payment->tytul = 'Kapitalizacja odsetek';
					$odsetki = round($company->stanKonta * (($company->bank->oprocentowanie/(12.0*100.0))) , 2);
					$payment->wartosc = $odsetki;
					$payment->czas = new CDbExpression('SYSDATE');
					$payment->save(false);

					$company->stanKonta += $odsetki;
					$company->updated = true;

					$undertakings[1] = array(
						'value'=>$odsetki,
						'who'=>strip_tags($company->bank->opis),
						'details'=>'Kapitalizacja odsetek ('.$company->bank->oprocentowanie.'%)',
					);
	                        	$company->save(false);
	                        	$transaction->commit();
				} 
                		catch (Exception $e)
                		{
                        		/*echo '<script type="text/javascript"> console.log('.$e->getMessage().'); </script>';*/
                        		$transaction->rollback();
                		}
                	}
		}

		return $undertakings;
/*
		$bank = Yii::app()->db->createCommand('
			select
				f."idBanku", b."nazwa", b."opis", b."oplataMiesieczna", b."oplataPrzelew",
					b."oplataZalozenie", b."oprocentowanie",
				nvl(MONTHS_BETWEEN(:now, (select t."czasRozpoczecia" from "Tura" t
					where t."idLekcji" = :startLesson and t."idKlasy" = f."idKlasy")), 0) "months",
				sum(nvl(o."wartosc", 0)) "payed"
			from "Firma" f
			left join "Oplaty" o on o."idBanku" = f."idBanku" and o."wartosc" < 0
			left join "Bank" b on b."id" = f."idBanku"
			where f."id" = :companyId and f."idBanku" is not null
			group by f."idBanku", b."nazwa", b."opis", b."oplataMiesieczna", b."oplataPrzelew",
				b."oplataZalozenie", b."oprocentowanie", f."idKlasy"
		')->queryRow(true, array(
			':now' => date('d-m-Y H:i:s'),
			':companyId' => $company->id,
			':startLesson' => -1
		));
		if (empty($bank))
			return false;

		$months = floor((float)$bank['months']);
		$payed = (float)$bank['payed'];
		$cost = (float)$bank['oplataMiesieczna'];

		$toPay = $months * $cost + $payed;

		if ($toPay > 0)
		{
			$payment = new Oplaty();
			$payment->idBanku = $bank['idBanku'];
			$payment->idFirmy = $company->id;
			$payment->rodzajOplaty = self::TYPE_BANK;
			$payment->tytul = 'Opłata miesięczna za usługi bankowe.';
			$payment->wartosc = $toPay;
			//$payment->save(false);

			$company->stanKonta -= $toPay;
			$company->updated = true;
		}
*/
	}
/*
	static public function analyzeKontrahentPayments(Firma &$company)
	{
		$kontrahenci = Yii::app()->db->createCommand('
			select x.*, nvl(y."payed",0) "payed", k."adres", k."nazwa" from (
				select xyz."idKontrahenta", sum(xyz."value") "topay" from (
					select f."idKontrahenta", f."cenaNetto" * f."stawkaVat" "value"
					from "Faktury" f
					where f."idFirmy" = :companyId and f."czyKoszt" = 1 and f."dataPlatnosci" is null and f."dataWystawienia" < (
						select * from (select bt."czasRozpoczecia" from "Firma" b
						left join "Tura" bt on b."idKlasy" = bt."idKlasy"
						where b."id" = :companyId
						order by bt."czasRozpoczecia" desc) where ROWNUM <= 1)
				union all
					select zf."idKontrahenta", z."cena" * z."kara" / 100 "value" from "ZlecenieFirmy" zf
					left join "Zlecenie" z on z."id" = zf."idZlecenia"
					where zf."czasZakonczenia" is not null and zf."idOdpowiedzi" is null and zf."idKontrahenta" is not null
						and zf."idGrupyPrzetargowej" is null and zf."idFirmy" = :companyId and zf."czasZakonczenia" < (
							select * from (select bt."czasRozpoczecia" from "Firma" b
							left join "Tura" bt on b."idKlasy" = bt."idKlasy"
							where b."id" = :companyId
							order by bt."czasRozpoczecia" desc) where ROWNUM <= 1)
				) xyz
				group by xyz."idKontrahenta") x
			left join (
				select o."idKontrahenta", sum(o."wartosc") "payed" from "Oplaty" o
				where o."idFirmy" = :companyId and o."wartosc" < 0 and o."idKontrahenta" is not null
				group by o."idKontrahenta"
			) y on x."idKontrahenta" = y."idKontrahenta"
			left join "Kontrahent" k on k."id" = x."idKontrahenta"
			where x."topay" <> nvl(y."payed",0)
		')->queryAll(true, array(':companyId' => $company->id));

		$undertakings = array();

		foreach ($kontrahenci as $kontrahent)
		{
			$undertaking = (float)$kontrahent['payed'] + (float)$kontrahent['topay'];

			if ($undertaking > 0)
			{
				$undertakings[] = array(
					'value' => $undertaking,
					'who' => $kontrahent['nazwa'] . ' (' . $kontrahent['adres'] . ')',
					'details' => 'Nieuregulowane faktury.'
				);
			}
			else if ($undertaking < 0)
			{
				//automatycznie ściągnij opłatę
				$payment = new Oplaty();
				$payment->idKontrahenta = $kontrahent['idKontrahenta'];
				$payment->idFirmy = $company->id;
				$payment->rodzajOplaty = self::TYPE_TASK_PAYMENT;
				$payment->tytul = 'Wyrównanie nadpłaty.';
				$payment->wartosc = abs($undertaking);
				//$payment->save(false);

				$company->stanKonta += $payment->wartosc;
				$company->updated = true;
			}
		}

		return $undertakings;
	}
*/
	static public function analyzeTaxPayments(Firma &$company, $lessonNumber)
	{
		if($lessonNumber == 7)
		{
			$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 1 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
			$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 7 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
		}
		else if($lessonNumber == 11)
		{
			$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 7 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
			$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 11 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
		}
		else if($lessonNumber == 15)
		{
			$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 11 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
			$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 15 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
		}

		$tax = Yii::app()->db->createCommand('select
			nvl(sum( round( case when "topay" > 0 then "topay" else 0 end ,2) ),0) "topay"
		from (select
				sum(case when o."rodzajOplaty" IN(1,2,3,11,13) and o."czas" > to_date(\''.$dateStart.'\', \'dd-mm-yyyy hh24:mi:ss\') and o."czas" < to_date(\''.$dateStop.'\', \'dd-mm-yyyy hh24:mi:ss\')
					then o."wartosc" else 0 end)*:tax "topay"
			from "Oplaty" o where o."idFirmy" = :companyId
		)')->queryRow(true, array(
			':tax' => ParametryGry::getFloat('PODATEK_DOCHODOWY', 0.18),
			':companyId' => $company->id
		));

		$undertakings = array();

		$undertaking = (float)$tax['topay'];

		//if($undertaking > 0)
		{
			$undertakings[] = array(
				'value' => $undertaking,
				'who' => 'Urząd skarbowy',
				'details' => 'Podatek dochodowy'
			);
		}

		return $undertakings;
	}

	static public function analyzeVatPayments(Firma &$company, $lessonNumber)
	{
		if($lessonNumber == 7)
		{
			$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 1 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
			$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 7 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
		}
		else if($lessonNumber == 11)
		{
			$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 7 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
			$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 11 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
		}
		else if($lessonNumber == 15)
		{
			$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 11 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
			$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 15 AND "idKlasy" = '.$company->idKlasy)->queryScalar();
		}

		$vat = (float)Yii::app()->db->createCommand('select (select
				sum(round(case when f."czyKoszt" > 0 then -1 else 1 end * f."stawkaVat" * f."cenaNetto", 2)) "x"
			from "Faktury" f
			where f."idFirmy" = :companyId and f."dataWystawienia" > to_date(\''.$dateStart.'\', \'dd-mm-yyyy hh24:mi:ss\') and f."dataWystawienia" < to_date(\''.$dateStop.'\', \'dd-mm-yyyy hh24:mi:ss\')
		) + (
			select nvl(round(sum(o."wartosc"),2), 0) from "Oplaty" o
			where o."idFirmy" = :companyId and o."rodzajOplaty" = 6 and o."wartosc" < 0
		) "vat" from dual')->queryScalar(array(':companyId' => $company->id));
//Yii::log("VAT: ".$vat);
		$undertakings = array();

		if($vat > 0)
		{
			$undertakings[] = array(
				'value' => $vat,
				'who' => 'Urząd skarbowy',
				'details' => 'Podatek VAT'
			);
		}
		else if ($vat < 0)
		{
			//automatycznie zwrot VAT

			$akcjePodsumowanie = null;
                        if($lessonNumber == 7)
                        {
                                $akcjePodsumowanie = AkcjaUzytkownika::model()->findAll(array(
                                        'condition'=>'"idFirmy" = :id_firmy AND "idAkcji" = :id_akcji',
                                        'params'=>array(
                                                ':id_firmy'=>$company->id,
                                                ':id_akcji'=>173,
                                        )
                                ));
                        }
                        elseif($lessonNumber == 11)
                        {
                                $akcjePodsumowanie = AkcjaUzytkownika::model()->findAll(array(
                                        'condition'=>'"idFirmy" = :id_firmy AND "idAkcji" = :id_akcji',
                                        'params'=>array(
                                                ':id_firmy'=>$company->id,
                                                ':id_akcji'=>174,
                                        )
                                ));
                        }
                        elseif($lessonNumber == 15)
                        {
                                $akcjePodsumowanie = AkcjaUzytkownika::model()->findAll(array(
                                        'condition'=>'"idFirmy" = :id_firmy AND "idAkcji" = :id_akcji',
                                        'params'=>array(
                                                ':id_firmy'=>$company->id,
                                                ':id_akcji'=>175,
                                        )
                                ));
                        }

                        if($akcjePodsumowanie == null)
                        {
				$transaction = Yii::app()->db->beginTransaction();
				try
				{
					$payment = new Oplaty();
					$payment->idFirmy = $company->id;
					$payment->rodzajOplaty = self::TYPE_VAT;
					$payment->tytul = 'Zwrot podatku VAT';
					$payment->wartosc = abs($vat);
					$payment->czas = new CDbExpression('SYSDATE');
					$payment->save(false);

					$company->stanKonta += $payment->wartosc;
					$company->updated = true;

					$undertakings[] = array(
                                		'value' => $vat,
                                		'who' => 'Urząd skarbowy',
                                		'details' => 'Podatek VAT (zwrot)'
                        		);

                        		$company->save(false);
                        		$transaction->commit();
				}
                        	catch (Exception $e)
                        	{
                                	/*echo '<script type="text/javascript"> console.log('.$e->getMessage().'); </script>';*/
                                	$transaction->rollback();
                        	}
                        }
		}

		return $undertakings;
	}

	static public function analyzeSalaryPayments(Firma &$company)
	{
/*
			select x.*, nvl(y."payed", 0) "payed", p."idDziedziny", p."imie",
				p."nazwisko", p."nip", p."pesel", p."urlAvatara"  from (select
					pf."idPracownika",
					sum(MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , :now), pf."dataZatrudnienia") * pf."wynagrodzenie") "topay",
					sum(MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , :now), pf."dataZatrudnienia")) "months",
					sum(case when pf."dataZwolnienia" is null then 1 else 0 end) "employed"
				from "PracownikFirmy" pf
				where pf."idFirmy" = :companyId
				group by pf."idPracownika"
			) x left join (
				select o."idPracownika", sum(o."wartosc") "payed" from "Oplaty" o
				where o."idFirmy" = :companyId and o."idPracownika" is not null and o."rodzajOplaty" = 4 and o."wartosc" < 0
				group by o."idPracownika"
			) y on x."idPracownika" = y."idPracownika"
			left join "Pracownik" p on x."idPracownika" = p."id"
			where nvl(y."payed", 0) + x."topay" > 0
*/

/*
			select x.*, nvl(y."payed", 0) "payed", p."idDziedziny", p."imie",
                                p."nazwisko", p."nip", p."pesel", p."urlAvatara"  from (select
                                        pf."idPracownika",
                                        sum(case when MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , TO_CHAR(SYSDATE)), pf."dataZatrudnienia") < 1 then 1 end ) "months",
                                        sum(case when MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , TO_CHAR(SYSDATE)), pf."dataZatrudnienia") < 1 then 1*pf."wynagrodzenie" 
                                                    else MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , TO_CHAR(SYSDATE)), pf."dataZatrudnienia")*pf."wynagrodzenie" end
                                           ) "topay",
                                        sum(case when pf."dataZwolnienia" is null then 1 else 0 end) "employed"
                                from "PracownikFirmy" pf
                                where pf."idFirmy" = :companyId
                                group by pf."idPracownika"
                        ) x left join (
                                select o."idPracownika", sum(o."wartosc") "payed" from "Oplaty" o
                                where o."idFirmy" = :companyId and o."idPracownika" is not null and o."rodzajOplaty" = 4 and o."wartosc" < 0
                                group by o."idPracownika"
                        ) y on x."idPracownika" = y."idPracownika"
                        left join "Pracownik" p on x."idPracownika" = p."id"
                        where nvl(y."payed", 0) + x."topay" > 0
*/

		$salaries = Yii::app()->db->createCommand('

    		    select x.*, 0 "payed", p."idDziedziny", p."imie", p."nazwisko", p."nip", p."pesel", p."urlAvatara" from 
    		    (
            		    select pf."idPracownika",
                    		    sum(case when MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , TO_CHAR(SYSDATE)), pf."dataZatrudnienia") < 1 then 1 end ) "months",
                    		    sum(case when MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , TO_CHAR(SYSDATE)), pf."dataZatrudnienia") < 1 then 1*pf."wynagrodzenie"
                                		else MONTHS_BETWEEN(nvl(pf."dataZwolnienia" , TO_CHAR(SYSDATE)), pf."dataZatrudnienia")*pf."wynagrodzenie" end
                       		       ) "topay",
                    		    sum(case when pf."dataZwolnienia" is null then 1 else 0 end) "employed"
            		    from "PracownikFirmy" pf
            		    where pf."idFirmy" = :companyId
            		    group by pf."idPracownika"
    		    )
    		    x 
    		    left join "Pracownik" p on x."idPracownika" = p."id"
    		    where x."topay" > 0

		')->queryAll(true, array(
			':now' => date('d-m-Y H:i:s'),
			':companyId' => $company->id
		));

		$undertakings = array();

		foreach ($salaries as $salary)
		{
			$undertaking = (float)$salary['topay'];

//			$undertaking = ($salary['employed'] ? (float)$salary['topay'] :
//				(float)$salary['topay']) + (float)$salary['payed'];

			if ($undertaking > 0)
			{
				//dolicz zobowiazania praodawcy wzgledem pracownika dla zus

				//to pay * % -> calkowie zooboizania - wplacone => ile sie nalezy

				$undertakings[] = array(
					'value' => $undertaking,
					'who' => $salary['imie'] . ' ' . $salary['nazwisko'], // . ' (' . $salary['pesel'] . ')',
					'details' => 'Wypłata dla pracownika'
				);
			}
		}

		return $undertakings;
	}

	public function getTarget()
	{
		if (!empty($this->idKontrahenta))
			return $this->kontrahent->nazwa;
		else if (!empty($this->idBanku))
			return $this->bank->opis;
		else if (!empty($this->idPracownika))
			return $this->pracownik->imie;
		else
			return '';
	}
}
